/*******************************************************************************
*
*	TITLE:		encoder.h 
*
*	VERSION:	0.4 (Beta)                           
*
*	DATE:		06-Jan-2005
*
*	AUTHOR:		R. Kevin Watson
*               Modified by Matt Haberland
*
*	COMMENTS:	You are free to use this source code for any non-commercial
*				use. Please do not make copies of this source code, modified
*				or un-modified, publicly available on the internet or
*				elsewhere without permission. Thanks.
*
*				Copyright 2004-2005 R. Kevin Watson. All rights are reserved.
*
********************************************************************************
*
*	CHANGE LOG:
*
*	DATE         REV  DESCRIPTION
*	-----------  ---  ----------------------------------------------------------
*	20-Dec-2003  0.1  RKW - Original code.
*	18-Feb-2004  0.2  RKW - Reassigned the encoder digital inputs to run
*	                  on the FRC robot controller too.
*	01-Jan-2005  0.3  RKW - Get_Left_Encoder_Count(), Get_Right_Encoder_Count(),
*	                  Set_Left_Encoder_Count() and Set_Right_Encoder_Count()
*	                  functions added.
*	01-Jan-2005  0.3  RKW - Renamed Int_1_Handler() and Int_2_Handler() to
*	                  Left_Encoder_Int_Handler() and Right_Encoder_Int_Handler
*	                  respectively.
*	01-Jan-2005  0.3  RKW - Altered the interrupt service routines to easily
*	                  flip the direction the encoders count by altering the
*	                  RIGHT_ENCODER_TICK_DELTA and LEFT_ENCODER_TICK_DELTA
*	                  #defines found in encoder.h
*	06-Jan-2005  0.4  RKW - Rebuilt with C18 version 2.40.
*   24-Mar-2005  0.5  MDH - Modified Kevin Watson's Code
*******************************************************************************/

#ifndef _encoder_h
#define _encoder_h

// Digital input pin assigned to the hip
// encoder's phase-B output. Make sure this pin
// is configured as an input in user_routines.c/
// User_Initialization().
#define HIP_ENCODER_PHASE_B_PIN	  rc_dig_int2

// change the sign of these if you need	to flip
// the way the encoders count. For instance, if
// a given encoder count increases in the positive 
// direction when rotating counter-clockwise, but 
// you want it to count in the negative direction 
// when rotating in the counter-clockwise direction,
// flip the sign and it'll work the way you need it
// to. 
#define HIP_ENCODER_TICK_DELTA 	1

// function prototypes
void Initialize_Encoder(void);			// call this to initialize the encoder software

long Get_Hip_Encoder_Count(void);		// call this to get the current hip encoder count

void Set_Hip_Encoder_Count(long);		// call this to set the hip encoder count

void Hip_Encoder_Int_Handler(void);	    // hip encoder interrupt handler

#endif
