% doublepenanimate.m    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Using PLOT and SET
%animation of pendulum
%This uses the output of doublependdriver.m
clf

n=length(t); dur=t(end);

% reference before translation and rotation
bar1ref = [0 1;0 0]; 
bar2ref = [0 1;0 0];


hinge=plot(0,0, 'marker','.','markersize',[50], ...
            'color','black');hold on;

axis('equal')
axis([-2 2.2 -2 2.2]); 

bar1pic=plot(bar1ref(1,:),bar1ref(2,:), ...
              'linewidth', 3, 'color','green');
bar2pic=plot(bar2ref(1,:)+1,bar1ref(2,:), ... % +1 for init disp
              'linewidth', 3, 'color','red');

set(bar1pic,'linewidth',7) % fatten bar 1 a bit

          
%Wallpaper
%Good to keep this outside of the plotting loop
%points = 4*rand(2,400)-2; 
%background = plot(points(1,:),points(2,:),'bo','markersize',20 )
       
pause(1)% Hold still for a second before starting

for i=1:n
    pause(.01)  %Use to control the speed of the animation

   th1=z(i,1);   th2=z(i,3);
   R1=[cos(th1) -sin(th1)	; sin(th1) cos(th1)]; % one rotation matrix
   R2=[cos(th2) -sin(th2)	; sin(th2) cos(th2)]; % another rotation matrix
   
   bar1=R1*bar1ref;
   bar2=R2*bar2ref; bar2offset=bar1(:,2);

   set(bar1pic,'xdata',bar1(1,:),'ydata',bar1(2,:));
   set(bar2pic,'xdata',bar2(1,:)+bar2offset(1), ...
               'ydata',bar2(2,:)+bar2offset(2)      );
 
end
