% doublepenanimate.m   
% USING SET  and DRAWNOW
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%animation of pendulum
%This uses the output of doublependdriver.m
clf

moviescaling=1;
n=length(t); dur=t(end);
delay =floor(moviescaling*1000*dur/n); %delay per frame in .001 secs 


bar1ref = [0 1;0 0];
bar2ref = [0 1;0 0];
axis('equal')
axis([-2 2 -2 2])
bar1pic=line('xdata',bar1ref(1,:),'ydata',bar1ref(2,:), ...
              'linewidth', 3, 'erase','xor','color','green');
bar2pic=line('xdata',bar2ref(1,:),'ydata',bar1ref(2,:), ...
              'linewidth', 3, 'erase','xor','color','red');
hinge=line('xdata',0,'ydata',0, 'marker','.','markersize',[30], ...
           'color','black','erase', 'xor');
drawnow

for i=1:n
   pause(.01)
	   
   th1=z(i,1);   th2=z(i,3);
   R1=[cos(th1) -sin(th1)	; sin(th1) cos(th1)]; % one rotation matrix
   R2=[cos(th2) -sin(th2)	; sin(th2) cos(th2)]; % another rotation matrix
   
   bar1=R1*bar1ref;
   bar2=R2*bar2ref; bar2offset=bar1(:,2);

   set(bar1pic,'xdata',bar1(1,:),'ydata',bar1(2,:));
   set(bar2pic,'xdata',bar2(1,:)+bar2offset(1), ...
               'ydata',bar2(2,:)+bar2offset(2)      );
   
end
