%doublependdriver.m
%Double pendulum simulation
%A. Ruina 
%This program works with   doublependderive.m
% which creates            douplependrhs.m.
%The animations done by    doublependanimate.m 

clear functions % This line is really needed, damn!

%Mechanical parameters.
m1     =  1;  m2     =  1; % masses
I1     = .5;  I2     = .5; % inertias about cms
M1     =  0;  M2     =  0; % torques at joints
LOtoG1 = .5              ; % O is shoulder
LOtoE  =  1;               % E is elbow
LEtoG2 =  1;               % G1 and G2 are com locations
g      = 10;

%Derive equations of motion and puts them in doublependrhs.m
%Comment the next line out after the first run
%doublependderive;  %Uses SOLVE command
doublependderive2;  %Uses JACOBIAN to extract a mass matrix

% Initial conditions and other settings.
framespersec=40;  %if view is not speeded or slowed in doublependanimate
ttot=30;          %duration of animation  in seconds
tspan=linspace(0,ttot,ttot*framespersec);
th1zero    = 0;
th1dotzero = 0;
th2zero    = 0 ;
th2dotzero = 0;

z0=[th1zero th1dotzero th2zero th2dotzero]';
options=odeset('abstol',1e-6,'reltol',1e-6);

[t z] = ode45('doublependrhs',[tspan],z0,options, ...
               m1, m2, I1, I2,   M1, M2, LOtoG1, ...
			   LOtoE, LEtoG2, g);
clf
figure(1)
plot(t,z(:,1),t,z(:,3));

figure(2)
% Animate the results: Three choices.
%doublependanimate1
%doublependanimate2
doublependanimate3
