function doublependderive2();
%derive the equations of motion of an undamped double
%pendulum
%This version uses the JACOBIAN function to extract a mass matrix


syms t th1 th1dot th1ddot th2  th2dot th2ddot    real
syms m1 m2 I1 I2   M1 M2 LOtoG1 LOtoE LEtoG2 g real
%M1 and M2 are applied torques at the shoulder and elbow

i=[1 0 0];  j=[0 1 0];    k=[0 0 1];



lam1 = [cos(th1) sin(th1) 0];   n1 = cross(k,lam1);
lam2 = [cos(th2) sin(th2) 0];   n2 = cross(k,lam2);

rOtoG1 = LOtoG1 * lam1;
rOtoE  = LOtoE  * lam1;
rEtoG2 = LEtoG2 * lam2;
rOtoG2 = rOtoE + rEtoG2;


aG1relO = -th1dot^2 * rOtoG1  +  cross(th1ddot*k, rOtoG1 );
aErelO  = -th1dot^2 * rOtoE   +  cross(th1ddot*k, rOtoE  );
aG2relE = -th2dot^2 * rEtoG2  +  cross(th2ddot*k, rEtoG2 );
aG2relO = aErelO + aG2relE;

MrelO = cross( rOtoG1,  -m1*g*j) + cross(rOtoG2, -m2*g*j) + M1;
MrelE = cross( rEtoG2,  -m2*g*j) + M2;

HdotrelO =  m1 * cross(rOtoG1,aG1relO) + I1*th1ddot*k ...
           +m2 * cross(rOtoG2,aG2relO) + I2*th2ddot*k ;
           
HdotrelE = m2 * cross(rEtoG2,aG2relO) + I2*th2ddot*k ;

eqn1 = MrelO - HdotrelO;   % Write EOM as: 0 = moment - Hdot
eqn2 = MrelE - HdotrelE;

eqn1 = eqn1(3);  %only the k component of the vector is non-zero
eqn2 = eqn2(3);

%Extract the coefficients of th1ddot and th2ddot using JACOBIAN
%Put them in a matrix M
M = simple(jacobian([eqn1 eqn2]', [th1ddot th2ddot]));


%Remove all the th1ddot stuff from the rhs
eqns = [eqn1; eqn2] - M*[th1ddot;th2ddot]; %like setting thddots to zero
r1char = char(simple(-eqns(1)));
r2char = char(simple(-eqns(2)));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Put derived equations  in a right-hand-side file for ode45.

fid=fopen(   'doublependrhs.m','w'                                    );
fprintf(fid, 'function zdot=doublependrhs3(t,z,flag,m1, m2, I1, ...\n');
fprintf(fid, '                              '                         );
fprintf(fid, 'I2, M1, M2, LOtoG1, LOtoE, LEtoG2, g);             \n\n');
fprintf(fid, 'th1    = z(1)             ;                          \n');
fprintf(fid, 'th1dot = z(2)             ;                          \n');
fprintf(fid, 'th2    = z(3)             ;                          \n');
fprintf(fid, 'th2dot = z(4)             ;                        \n\n');

%Write out the components of the mass matrix, one at a time
n=2;  % Number of equations
fprintf(fid, ['n =' num2str(n) ';   M=zeros(n);\n']);
for i=1:n;   for j=1:n   % M(i,j) = symbolic expressions for M(i,j)
   fprintf(fid, ['M(' num2str(i) ',' num2str(j) ') ='  char(M(i,j)) ';\n']);
end; end

fprintf(fid, ['rhs = [' r1char ';' r2char '];\n']);

% The fprintf command doesn't deal well with \, so use mldivide instead
fprintf(fid, ['alphas = mldivide(M,rhs);\n\n']);

fprintf(fid,['alpha1 = alphas(1);\n']);
fprintf(fid,['alpha2 = alphas(2);\n']);

fprintf(fid, 'zdot = [th1dot alpha1 th2dot alpha2]''  ;            \n');
fclose(fid);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%latex(simple(r1))
%latex(simple(r2))
